set term postscript eps enhanced color "Times-Roman, 26" size 10,6
set output 'bands.eps'
set autoscale
set encoding iso_8859_1

Ef = 2.6459
Ry = 13.605693
K = 0.16/2
a = 2.46*5
dk = 100*2*3.141592/a

set multiplot layout 2,1

unset xtic
set xzeroaxis lw 2 dt 3 
set tmargin 1
set bmargin 2
set size 0.62, 0.95
set origin 0.0, 0.02
set xrange [0.0:1.000]
set ytic auto out nomirror
set tics out scale 2,1 nomirror
set yrange [-1.25:1.25]
unset xtics
set key inside top left samplen 1 box opaque
set mytics 5
set title ""
#set label "(a)" at -0.2,1.25
#set label "(b)" at 1.1,1.25
set xtics ("M" 0.0, "K" 0.3333, "{/Symbol G}" 1.0 ) out nomirror scale 2,1
set ylabel "E - E_F [eV]" offset 2,0
plot "./band_up.dat.gnu" using 1:($2-Ef) with lines lc rgb "red" lw 4 lt 1 title "spin up" ,\
"./band_down.dat.gnu" using 1:($2-Ef) with lines lc rgb "blue" lw 4 dt 3 title "spin dn",\


unset xtic
set xzeroaxis dt 3 lw 2
set tmargin 1
unset label
set bmargin 2
set size 0.38, 0.9
set origin 0.62, 0.02
set ytic auto out nomirror
set xrange [-3:3]
set tics out scale 2,1 nomirror
set yrange [-20:30]
set key inside top center samplen 1 box opaque
set ytics -500,10,500 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
set xtics ("M" -3 , "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 3 ) out nomirror scale 2,1
set x2tics ("4" -4, "3" -3, "2" -2, "1" -1, "0" 0, "1" 1, "2" 2, "4" 4) offset 0,-0.5
set mx2tics 2
unset colorbox
set palette defined (-0.5 'blue', -0.3 'grey', 0 'grey', 0.3 'grey', 0.5 'red')
set x2label "k [10^{-2}/{\305}]" offset 0,-0.5
plot "./bandsK/band_up.dat.gnu" using (($1-K)*dk):(1000*($2-Ef)) with lines lc rgb "red" lw 4 title "",\
"./bandsK/band_down.dat.gnu" using (($1-K)*dk):(1000*($2-Ef)) with lines lc rgb "blue" lw 4 dt 3 title ""
#"./band_down.dat.gnu" using (($1-K)*dk):(1000*($2-Ef-500)) with points lt 6 ps 1.2 lc rgb "black" lw 2 title "DFT",\
#"./bands_model.dat" using (($1*100)):(1000*($2)) with lines lw 5 lc rgb "black" title "Model",\
#"./bands_model.dat" using (($1*100)):(1000*($2)):10 palette lw 5 with lines title "",\
#"./bands_model.dat" using (($1*100)):(1000*($3)):11 palette lw 5 with lines title "",\
#"./bands_model.dat" using (($1*100)):(1000*($4)):12 palette lw 5 with lines title "",\
#"./bands_model.dat" using (($1*100)):(1000*($5)):13 palette lw 5 with lines title "",\
#"./bands_model.dat" using (($1*100)):(1000*($6)):14 palette lw 5 with lines title "",\
#"./bands_model.dat" using (($1*100)):(1000*($7)):15 palette lw 5 with lines title "",\
#"./bands_model.dat" using (($1*100)):(1000*($8)):16 palette lw 5 with lines title "",\
#"./bands_model.dat" using (($1*100)):(1000*($9)):17 palette lw 5 with lines title ""



