set term postscript eps enhanced color "Times-Roman, 28" size 10,6
set output 'bands.eps'
set autoscale
set encoding iso_8859_1

Ef = 2.5982
Ry = 13.605693
K = 0.16/2
a = 2.46*5
dk = 100*2*3.141592/a
set multiplot layout 2,1

unset xtic
set xzeroaxis lw 2 dt 3 
set tmargin 1
set bmargin 2
set size 0.59, 0.95
set origin 0.0, 0.02
set xrange [0.0:1.000]
set ytic auto out nomirror offset 0.5,0
set tics out scale 2,1 nomirror
set yrange [-1.25:1.25]
unset xtics
set key inside top left samplen 1 box opaque
set mytics 5
set title ""
set xtics ("M" 0.0, "K" 0.3333, "{/Symbol G}" 1.0 ) out nomirror scale 2,1 offset 0,0.5
set ylabel "E - E_F [eV]" offset 3,0
plot "../band_up.dat.gnu" using 1:($2-Ef) with lines lc rgb "red" lw 4 lt 1 title "spin up" ,\
"../band_down.dat.gnu" using 1:($2-Ef) with lines lc rgb "blue" lw 4 lt 1 title "spin dn",\


unset xtic
set xzeroaxis dt 3 lw 2
set tmargin 1
unset label
set bmargin 2
set size 0.37, 0.9
set origin 0.565, 0.02
set ytic auto out nomirror
set xrange [-3:3]
set tics out scale 2,1 nomirror
set yrange [-15:30]
set key inside top center samplen 1 box opaque
set ytics -500,5,500 out nomirror offset 0.5,0
unset xtics
set ylabel "E - E_F [meV]" offset 2,0
set mytics 2
set xtics ("M" -3 , "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 3 ) out nomirror scale 2,1 offset 0,0.5
set x2tics ("4" -4, "3" -3, "2" -2, "1" -1, "0" 0, "1" 1, "2" 2, "3" 3) offset 0,-0.5
set mx2tics 2
unset colorbox
set palette defined (-0.5 'blue', -0.3 'grey', 0 'grey', 0.3 'grey', 0.5 'red')
set x2label "k [10^{-2}/{\305}]" offset 0,-0.5
plot "../bandsK/band_up.dat.gnu" using (($1-K)*dk):(1000*($2-Ef)) every 4 with points lt 7 ps 1.8 lc rgb "red" lw 2 title "",\
"../bandsK/band_down.dat.gnu" using (($1-K)*dk):(1000*($2-Ef)) every 4 with points lt 7 ps 1.8 lc rgb "blue" lw 2 title "",\
"../bandsK/band_down.dat.gnu" using (($1-K)*dk):(1000*($2-Ef-500)) every 4 with points lt 7 ps 1.8 lc rgb "black" lw 2 title "DFT",\
"./bands_model.dat" using (($1*100)):(1000*($2)) with lines lw 5 lc rgb "black" title "Model",\
"./bands_model.dat" using (($1*100)):(1000*($2)):38 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($3)):39 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($4)):40 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($5)):41 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($6)):42 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($7)):43 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($8)):44 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($9)):45 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($10)):46 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($11)):47 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($12)):48 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($13)):49 palette lw 5 with lines title ""











