#!/usr/bin/python
import numpy as np
import cmath
from cmath import*
from sympy.physics.quantum.dagger import Dagger
import math
from lmfit import Model
import time
import matplotlib.pyplot as plt

agrp = 2.46e-10
size = 4.0
a = agrp*size
hbar = 6.582119e-16
pi = math.pi

#Orbital parameters
g0 = 2.54817708
g1 = 0.40282287
g2 = -0.01191080
g3 = 0.31017745
g4 = -0.17645345
g5 = 0.01808742
V1 = 7.6807e-05
V2 = -0.00627808
delta = 0.022083866
eta = 0.00657153
ED = 0.0


#Spin-Orbit coupling parameters
LiA1 = 0.00020440
LiB1 = 	-0.00020565#responsible for LE
LiA2 = 0.0
LiB2 = 0.0
LiA3 = 0.00099536#0.00112458	#responsible for LE
LiB3 = -0.00101069#-0.00098257
LBR1 = 0.00021542
LBR2 = 0.0
LBR3 = -0.00045866


#Exchange coupling parameters
BexA1 = 0.0
BexB1 = 0.0
BexA2 = 0.0
BexB2 = 0.0
BexA3 = 0.0
BexB3 = 0.0

tau = 1
#DFT daten#
k1 = []
k2 = []
kx = []
ky = []

grid = 5000
for i in range(grid):
	for j in range(grid):
		k1.append(-0.10+i*(0.20/grid))
		k2.append(-0.10+j*(0.20/grid))
		
kmax=len(k1)

for i in range(0,kmax):
	kx.append(int(((4*pi/(sqrt(3)*a))*(k1[i]*sqrt(3.)/2.)).real))
	ky.append(int(((4*pi/(sqrt(3)*a))*(k1[i]*(1./2.)+k2[i])).real))



# basis is: A1up, A1dn, B1up, B1dn, A2up, A2dn, B2up, B2dn, A3up, A3dn, B3up, B3dn
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
def Hamiltonian(kx,ky,tau,ED,g0,g1,g2,g3,g4,g5,delta,eta,V1,V2,LiA1,LiB1,LiA2,LiB2,LiA3,LiB3,LBR1,LBR2,LBR3,BexA1,BexB1,BexA2,BexB2,BexA3,BexB3):

	#FK = exp(  complex(0.0,a*ky/  sqrt(3.0)  )  )* (  1+2*exp(  complex(  0.0,-sqrt(3.0)*a*ky/2.0  )  )*cos(a*kx/2.0)  )
	#CFK = np.conjugate(FK)

	FK = (1./2.)*sqrt(3.)*(agrp)*complex(-kx,ky)		#linearized version of structure function
	CFK = np.conjugate(FK)
	
	h11 = delta+tau*LiA1-BexA1+V1
	h12 = 0.0
	h13 = g0*FK
	h14 = complex(0.0,LBR1)*(1-tau)
	h15 = g4*CFK
	h16 = 0.0
	h17 = g1
	h18 = 0.0
	h19 = g5
	h110 = 0.0
	h111 = 0.0
	h112 = 0.0

	h21 = 0.0
	h22 = delta-tau*LiA1+BexA1+V1
	h23 = complex(0.0,LBR1)*(1+tau)
	h24 = g0*FK
	h25 = 0.0
	h26 = g4*CFK
	h27 = 0.0
	h28 = g1
	h29 = 0.0
	h210 = g5
	h211 = 0.0
	h212 = 0.0

	h31 = g0*CFK
	h32 = -complex(0.0,LBR1)*(1+tau)
	h33 = eta-tau*LiB1-BexB1+V1
	h34 = 0.0
	h35 = g3*FK
	h36 = 0.0
	h37 = g4*CFK
	h38 = 0.0
	h39 = 0.0
	h310 = 0.0
	h311 = g2
	h312 = 0.0

	h41 = -complex(0.0,LBR1)*(1-tau)
	h42 = g0*CFK
	h43 = 0.0
	h44 = eta+tau*LiB1+BexB1+V1
	h45 = 0.0
	h46 = g3*FK
	h47 = 0.0
	h48 = g4*CFK
	h49 = 0.0
	h410 = 0.0
	h411 = 0.0
	h412 = g2

	h51 = g4*FK
	h52 = 0.0
	h53 = g3*CFK
	h54 = 0.0
	h55 = tau*LiA2-BexA2+V2
	h56 = 0.0
	h57 = g0*FK
	h58 = complex(0.0,LBR2)*(1-tau)
	h59 = g4*FK
	h510 = 0.0
	h511 = g3*CFK
	h512 = 0.0

	h61 = 0.0
	h62 = g4*FK
	h63 = 0.0
	h64 = g3*CFK
	h65 = 0.0
	h66 = -tau*LiA2+BexA2+V2
	h67 = complex(0.0,LBR2)*(1+tau)
	h68 = g0*FK
	h69 = 0.0
	h610 = g4*FK
	h611 = 0.0
	h612 = g3*CFK

	h71 = g1
	h72 = 0.0
	h73 = g4*FK
	h74 = 0.0
	h75 = g0*CFK
	h76 = -complex(0.0,LBR2)*(1+tau)
	h77 = delta-tau*LiB2-BexB2+V2
	h78 = 0.0
	h79 = g1
	h710 = 0.0
	h711 = g4*FK
	h712 = 0.0

	h81 = 0.0
	h82 = g1
	h83 = 0.0
	h84 = g4*FK
	h85 = -complex(0.0,LBR2)*(1-tau)
	h86 = g0*CFK
	h87 = 0.0
	h88 = delta+tau*LiB2+BexB2+V2
	h89 = 0.0
	h810 = g1
	h811 = 0.0
	h812 = g4*FK

	h91 = g5
	h92 = 0.0
	h93 = 0.0
	h94 = 0.0
	h95 = g4*CFK
	h96 = 0.0
	h97 = g1
	h98 = 0.0
	h99 = delta+tau*LiA3-BexA3-V1
	h910 = 0.0
	h911 = g0*FK
	h912 = complex(0.0,LBR3)*(1-tau)

	h101 = 0.0
	h102 = g5
	h103 = 0.0
	h104 = 0.0
	h105 = 0.0
	h106 = g4*CFK
	h107 = 0.0
	h108 = g1
	h109 = 0.0
	h1010 = delta-tau*LiA3+BexA3-V1
	h1011 = complex(0.0,LBR3)*(1+tau)
	h1012 = g0*FK

	h111 = 0.0
	h112 = 0.0
	h113 = g2
	h114 = 0.0
	h115 = g3*FK
	h116 = 0.0
	h117 = g4*CFK
	h118 = 0.0
	h119 = g0*CFK
	h1110 = -complex(0.0,LBR3)*(1+tau)
	h1111 = eta-tau*LiB3-BexB3-V1
	h1112 = 0.0

	h121 = 0.0
	h122 = 0.0
	h123 = 0.0
	h124 = g2
	h125 = 0.0
	h126 = g3*FK
	h127 = 0.0
	h128 = g4*CFK
	h129 = -complex(0.0,LBR3)*(1-tau)
	h1210 = g0*CFK
	h1211 = 0.0
	h1212 =	eta+tau*LiB3+BexB3-V1
	

	H = np.array([[h11,h12,h13,h14,h15,h16,h17,h18,h19,h110,h111,h112],
		      [h21,h22,h23,h24,h25,h26,h27,h28,h29,h210,h211,h212],
		      [h31,h32,h33,h34,h35,h36,h37,h38,h39,h310,h311,h312],
		      [h41,h42,h43,h44,h45,h46,h47,h48,h49,h410,h411,h412],
		      [h51,h52,h53,h54,h55,h56,h57,h58,h59,h510,h511,h512], 
		      [h61,h62,h63,h64,h65,h66,h67,h68,h69,h610,h611,h612],
		      [h71,h72,h73,h74,h75,h76,h77,h78,h79,h710,h711,h712],
		      [h81,h82,h83,h84,h85,h86,h87,h88,h89,h810,h811,h812],
		      [h91,h92,h93,h94,h95,h96,h97,h98,h99,h910,h911,h912], 
		      [h101,h102,h103,h104,h105,h106,h107,h108,h109,h1010,h1011,h1012],
		      [h111,h112,h113,h114,h115,h116,h117,h118,h119,h1110,h1111,h1112],
		      [h121,h122,h123,h124,h125,h126,h127,h128,h129,h1210,h1211,h1212]])

	Sx = np.array([ [0,1,0,0,0,0,0,0,0,0,0,0],
			[1,0,0,0,0,0,0,0,0,0,0,0],
			[0,0,0,1,0,0,0,0,0,0,0,0],
			[0,0,1,0,0,0,0,0,0,0,0,0],
			[0,0,0,0,0,1,0,0,0,0,0,0],
			[0,0,0,0,1,0,0,0,0,0,0,0],
			[0,0,0,0,0,0,0,1,0,0,0,0],
			[0,0,0,0,0,0,1,0,0,0,0,0],
			[0,0,0,0,0,0,0,0,0,1,0,0],
			[0,0,0,0,0,0,0,0,1,0,0,0],
			[0,0,0,0,0,0,0,0,0,0,0,1],
			[0,0,0,0,0,0,0,0,0,0,1,0]])

	Sy = np.array([ [0,complex(0,-1),0,0,0,0,0,0,0,0,0,0],
			[complex(0,1),0,0,0,0,0,0,0,0,0,0,0],
			[0,0,0,complex(0,-1),0,0,0,0,0,0,0,0],
			[0,0,complex(0,1),0,0,0,0,0,0,0,0,0],
			[0,0,0,0,0,complex(0,-1),0,0,0,0,0,0],
			[0,0,0,0,complex(0,1),0,0,0,0,0,0,0],
			[0,0,0,0,0,0,0,complex(0,-1),0,0,0,0],
			[0,0,0,0,0,0,complex(0,1),0,0,0,0,0],
			[0,0,0,0,0,0,0,0,0,complex(0,-1),0,0],
			[0,0,0,0,0,0,0,0,complex(0,1),0,0,0],
			[0,0,0,0,0,0,0,0,0,0,0,complex(0,-1)],
			[0,0,0,0,0,0,0,0,0,0,complex(0,1),0],])

	Sz = np.array([ [1,0,0,0,0,0,0,0,0,0,0,0],
			[0,-1,0,0,0,0,0,0,0,0,0,0],
			[0,0,1,0,0,0,0,0,0,0,0,0],
			[0,0,0,-1,0,0,0,0,0,0,0,0],
			[0,0,0,0,1,0,0,0,0,0,0,0],
			[0,0,0,0,0,-1,0,0,0,0,0,0],
			[0,0,0,0,0,0,1,0,0,0,0,0],
			[0,0,0,0,0,0,0,-1,0,0,0,0],
			[0,0,0,0,0,0,0,0,1,0,0,0],
			[0,0,0,0,0,0,0,0,0,-1,0,0],
			[0,0,0,0,0,0,0,0,0,0,1,0],
			[0,0,0,0,0,0,0,0,0,0,0,-1],])

	evals, evecs = np.linalg.eigh(H)

	ew=[[],[],[],[],[],[],[],[],[],[],[],[]]
	spinx=[[],[],[],[],[],[],[],[],[],[],[],[]]
	spiny=[[],[],[],[],[],[],[],[],[],[],[],[]]
	spinz=[[],[],[],[],[],[],[],[],[],[],[],[]]



	for i in range(0,12):
		ew[i] = evals[i]+ED
		EV = evecs[:,i]
		DEV = Dagger(evecs[:,i])
		spinx[i]=1./2.*(DEV.dot(Sx.dot(EV))).real
		spiny[i]=1./2.*(DEV.dot(Sy.dot(EV))).real	
		spinz[i]=1./2.*(DEV.dot(Sz.dot(EV))).real	
	
	
	return ew[0],ew[1],ew[2],ew[3],ew[4],ew[5],ew[6],ew[7],ew[8],ew[9],ew[10],ew[11]#,spinx[0],spinx[1],spinx[2],spinx[3],spinx[4],spinx[5],spinx[6],spinx[7],spinx[8],spinx[9],spinx[10],spinx[11],spiny[0],spiny[1],spiny[2],spiny[3],spiny[4],spiny[5],spiny[6],spiny[7],spiny[8],spiny[9],spiny[10],spiny[11],spinz[0],spinz[1],spinz[2],spinz[3],spinz[4],spinz[5],spinz[6],spinz[7],spinz[8],spinz[9],spinz[10],spinz[11]

	
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
dE = 0.1e-3
smearing = 0.08e-3
dos =[0 for y in range(800)]
Energies = [0 for y in range(800)]

for i in range(0,kmax):
	EW = Hamiltonian(kx[i],ky[i],tau,ED,g0,g1,g2,g3,g4,g5,delta,eta,V1,V2,LiA1,LiB1,LiA2,LiB2,LiA3,LiB3,LBR1,LBR2,LBR3,BexA1,BexB1,BexA2,BexB2,BexA3,BexB3)
	for j in range(800):
		Eavg = -40e-3+j*dE
		Emin = Eavg-smearing
		Emax = Eavg+smearing
		Energies[j]=Eavg
		for l in range(len(EW)):
			if Emin <= EW[l] < Emax:
				dos[j] = dos[j]+1

for j in range(800):
	print ("%5.7f %5.1f" % (Energies[j], dos[j]))






#for each energy interval go through all entries in Energies. If entry is in an interval of smearing around Eavg, append them into tmp-file. 






