set term postscript eps enhanced color "Times-Roman, 26" size 10,6
set output 'bands.eps'
set autoscale
set encoding iso_8859_1

Ef = 3.4128
K = 0.16/2
a = 2.46*4
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1


unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.5, 0.90
set origin 0.02, 0.02
set ytic auto out nomirror
set xrange [-4:4]
set tics out scale 2,1 nomirror
set yrange [-650:680]
set key inside top center samplen 1 box opaque
set ytics -700,100,700 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
set xtics ("M" -4 , "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 4 ) out nomirror
set x2tics ("4" -4, "2" -2, "0" 0, "2" 2, "4" 4) offset 0,-0.5
set mx2tics 4
set palette defined (-0.5 'blue', -0.1 'grey', 0 'grey', 0.1 'grey', 0.5 'red')
set cbrange [-0.5:0.5]
set cbtics -1,0.5,1 offset -0.5,0
set cblabel "< s_z >" offset -0.7,0
set colorbox user origin 0.25,0.6 size 0.012,0.12
set x2label "k [10^{-2}/{\305}]" offset 0,-0.5
plot "../bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-Ef)):9 every 7 palette lt 7 ps 1.4 lw 2 with points title "",\
"../bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-Ef-500)) lc rgb "black" lt 7 ps 1.4 lw 2 with points title "DFT",\
"./bands_model.dat" using (($1*100)):(1000*($2)) with lines lw 5 lc rgb "black" title "Model",\
"./bands_model.dat" using (($1*100)):(1000*($2)):38 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($3)):39 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($4)):40 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($5)):41 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($6)):42 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($7)):43 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($8)):44 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($9)):45 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($10)):46 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($11)):47 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($12)):48 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($13)):49 palette lw 5 with lines title ""


unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.5, 0.30
set origin 0.5, 0.65
set ytic auto out nomirror
set xrange [-5:5]
set tics out scale 2,1 nomirror
set yrange [0:1.5]
set key inside top center samplen 1 box opaque
set ytics 0,1,6 out nomirror
unset xtics
set ylabel "splitting [meV]" offset 0.5,0
set mytics 2
unset x2tics
unset x2label
unset colorbox
plot "./bands_model.dat" using (($1*100)):(1000*($13-$12)) with lines lw 5 lc rgb "red" title "",\
"./bands_model.dat" using (($1*100)):(1000*($11-$10)) with lines lw 5 lc rgb "blue" title "",\
"./bands_model.dat" using (($1*100)):(1000*($61-$60)) every 6 with points pt 7 ps 1.4 lc rgb "red" title "",\
"./bands_model.dat" using (($1*100)):(1000*($59-$58)) every 6 with points pt 7 ps 1.4 lc rgb "blue" title "",\


unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.5, 0.30
set origin 0.5, 0.3
set ytic auto out nomirror
set xrange [-5:5]
set tics out scale 2,1 nomirror
set yrange [0:2]
set key inside top center samplen 1 box opaque
set ytics 0,1,6 out nomirror
unset xtics
set ylabel "splitting [meV]" offset 0.5,0
set mytics 2
unset colorbox
plot "./bands_model.dat" using (($1*100)):(1000*($9-$8)) with lines lw 5 lc rgb "red" title "",\
"./bands_model.dat" using (($1*100)):(1000*($7-$6)) with lines lw 5 lc rgb "blue" title "",\
"./bands_model.dat" using (($1*100)):(1000*($57-$56)) every 6 with points pt 7 ps 1.4 lc rgb "red" title "",\
"./bands_model.dat" using (($1*100)):(1000*($55-$54)) every 6 with points pt 7 ps 1.4 lc rgb "blue" title "",\




unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.5, 0.30
set origin 0.5, 0.02
set ytic auto out nomirror
set xrange [-5:5]
set tics out scale 2,1 nomirror
set yrange [0:2]
set key inside top center samplen 1 box opaque
set ytics 0,1,6 out nomirror
unset xtics
set ylabel "splitting [meV]" offset 0.5,0
set mytics 2
unset colorbox
plot "./bands_model.dat" using (($1*100)):(1000*($5-$4)) with lines lw 5 lc rgb "red" title "",\
"./bands_model.dat" using (($1*100)):(1000*($3-$2)) with lines lw 5 lc rgb "blue" title "",\
"./bands_model.dat" using (($1*100)):(1000*($53-$52)) every 6 with points pt 7 ps 1.4 lc rgb "red" title "",\
"./bands_model.dat" using (($1*100)):(1000*($51-$50)) every 6 with points pt 7 ps 1.4 lc rgb "blue" title "",\






