set term postscript eps enhanced color "Times-Roman, 24" size 6,6
set output 'spinfield.eps'
set autoscale
set encoding iso_8859_1

ECBE = -0.3280840
EVBE = -0.3293720
Ry = 13.605693009
h = 6.582119e-16
tau = 100e-15
kx = 0.3333333
ky = 0.5773502
a = 2.4858*5
bz = 100*2*3.141592/a

set multiplot layout 2,1 title ""



set xrange [-2.3:2.3]
set title ""
set arrow from 0.0,0.0 to -2.3, 0 lw 4 lc rgb "white" dt 6 nohead front 
set arrow from 0.0,0.0 to 1.3,2.25 lw 4 lc rgb "white" dt 6 nohead front
set arrow from 0.0,0.0 to 1.3,-2.25 lw 4 lc rgb "white" dt 6 nohead front
set ytics -3,1,3 out scale 1,1 nomirror offset 0.8,0
set xtics -3,1,3 out scale 1,1 nomirror offset 0,0.8
set pm3d interpolate 3,3
set view map
set ylabel "k_y [10^{-2}/{\305}]" offset 0.2,0
set xlabel "k_x [10^{-2}/{\305}]" offset 0,1
set yrange [-2.3:2.3]
set tmargin 1
set bmargin 2
unset label
unset colorbox
set size 0.5, 0.5
set origin 0.05, 0.5
set title ""
set cbrange [-0.5:0.5]
set cbtics -0.5,0.5,0.5 offset -0.6,0
set cblabel " {\74} s_z {\76}" offset -1.5,0
set colorbox user origin 0.49,0.47 size 0.015,0.1
set palette defined (-0.5 "blue", -0.4 "grey", 0 "white", 0.4 "grey", 0.5 "red")
splot "data_CB.dat" u (bz*($1-kx)):(bz*($2-ky)):($6) w pm3d title "",\
"data_CB.dat" u (bz*($1-kx)):(bz*($2-ky)):(1):($4*5):($5*5):(1) every 1 with vectors head lt 1 lc -1 lw 2 filled title ""

set tmargin 1
set bmargin 2
set size 0.5, 0.5
set origin 0.52, 0.5
splot "data_CB.dat" u (bz*($1-kx)):(bz*($2-ky)):($10) w pm3d title "",\
"data_CB.dat" u (bz*($1-kx)):(bz*($2-ky)):(1):($8*5):($9*5):(1) every 1 with vectors head lt 1 lc -1 lw 2 filled title ""


set tmargin 1
set bmargin 2
set size 0.5, 0.5
set origin 0.05, 0.05
splot "data_VB.dat" u (bz*($1-kx)):(bz*($2-ky)):($10) w pm3d title "",\
"data_VB.dat" u (bz*($1-kx)):(bz*($2-ky)):(1):($8*5):($9*5):(1) every 1 with vectors head lt 1 lc -1 lw 2 filled title ""

set tmargin 1
set bmargin 2
set size 0.5, 0.5
set origin 0.52, 0.05
splot "data_VB.dat" u (bz*($1-kx)):(bz*($2-ky)):($6) w pm3d title "",\
"data_VB.dat" u (bz*($1-kx)):(bz*($2-ky)):(1):($4*5):($5*5):(1) every 1 with vectors head lt 1 lc -1 lw 2 filled title ""

