set term postscript eps enhanced color "Times-Roman, 30" size 6,7
set output 'bands.eps'
set autoscale
set encoding iso_8859_1

Ef = 3.4128
K = 0.12/2
a = 2.46*4
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1

unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.98, 0.98
set origin 0.02, 0.01
set ytic auto out nomirror
set xrange [-2.5:4]
set tics out scale 2,1 nomirror
set yrange [-50:50]
unset key
set ytics -600,10,600 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
set xtics ("M" -2.5, "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 4 ) out nomirror scale 2,1
unset x2label
plot "G1.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 8 lc rgb "red" title "G1",\
"G2.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 6 lc rgb "blue" title "G2",\
"G3.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 4 lc rgb "green" title "G3"










