set term postscript eps enhanced color "Times-Roman, 30" size 4,6
set output 'bands2.eps'
set autoscale
set encoding iso_8859_1

Ef = 3.4128
K = 0.12/2
a = 2.46*4
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1


unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.98, 0.3
set origin 0.02, 0.01
set ytic auto out nomirror
set xrange [-2.5:4]
set tics out scale 2,1 nomirror
set yrange [-600:-535]
set key inside top center samplen 1 box opaque
set ytics -600,50,600 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
set xtics ("M" -2.5, "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 4 ) out nomirror scale 2,1
set x2tics ("4" -4, "2" -2, "0" 0, "2" 2, "4" 4) offset 0,-0.5
set mx2tics 4
unset x2tics
unset colorbox
set x2label "k [10^{-2}/{\305}]" offset 0,-0.5
unset x2label
unset key
plot "A2.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 7 lc rgb "red" title "G1",\
"B2.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 6 lc rgb "blue" title "G2"

unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.955, 0.5
set origin 0.045, 0.26
set ytic auto out nomirror
set tics out scale 2,1 nomirror
set yrange [-40:40]
set key inside top center samplen 1 box opaque
set ytics -600,20,600 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
unset key
plot "A2.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 7 lc rgb "red" title "A1",\
"B2.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 6 lc rgb "blue" title "G2"


unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.98, 0.3
set origin 0.02, 0.7
set ytic auto out nomirror
set tics out scale 2,1 nomirror
set yrange [595:630]
set key inside top center samplen 1 nobox opaque maxrows 2
set ytics -600,20,650 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
unset colorbox
plot "A2.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 7 lc rgb "red" title "A2",\
"B2.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 6 lc rgb "blue" title "B2"







