set term postscript eps enhanced color "Times-Roman, 26" size 10,6
set output 'bands.eps'
set autoscale
set encoding iso_8859_1

Ef = 3.4270
K = 0.16/2
a = 2.46*4
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1

unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
set bmargin 2
set size 0.62, 0.95
set origin 0.0, 0.02
set xrange [0.0:1.]
set ytic auto out nomirror
set tics out scale 2,1 nomirror
set yrange [-1:1.5]
unset xtics
unset key
set mytics 5
set title ""
#set label "(a)" at -0.2,1.25
#set label "(b)" at 1.7,1.25
set palette defined (-0.5 'blue', -0.1 'grey', 0 'grey', 0.1 'grey', 0.5 'red')
set cbrange [-0.5:0.5]
set cbtics -1,0.5,1 offset -0.5,0
set cblabel "< s_z >" offset -0.7,0
set colorbox user origin 0.5,0.5 size 0.012,0.12
set xtics ("M" 0.0, "K" 0.3333, "{/Symbol G}" 1.0,"M" 1.5774  ) out nomirror scale 2,1
set ylabel "E - E_F [eV]" offset 2,0
plot "../spinbands.dat" using 1:($2-Ef):9 palette lw 6 with lines 


unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.38, 0.90
set origin 0.63, 0.02
set ytic auto out nomirror
set xrange [-3:3]
set tics out scale 2,1 nomirror
set yrange [360:435]
set key inside top center samplen 1 box opaque
set ytics -500,5,500 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
set xtics ("M" -3 , "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 3 ) out nomirror
set x2tics ("4" -4, "2" -2, "0" 0, "2" 2, "4" 4) offset 0,-0.5
set mx2tics 4
unset colorbox
set x2label "k [10^{-2}/{\305}]" offset 0,-0.5
plot "../bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-Ef)):9 every 3 palette lt 7 ps 1.4 lw 2 with points title "",\
"../bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-Ef-500)) lc rgb "black" lt 7 ps 1.4 lw 2 with points title "DFT",\
"./bands_model.dat" using (($1*100)):(1000*($2)) with lines lw 5 lc rgb "black" title "Model",\
"./bands_model.dat" using (($1*100)):(1000*($2)):38 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($3)):39 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($4)):40 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($5)):41 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($6)):42 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($7)):43 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($8)):44 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($9)):45 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($10)):46 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($11)):47 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($12)):48 palette lw 5 with lines title "",\
"./bands_model.dat" using (($1*100)):(1000*($13)):49 palette lw 5 with lines title ""











