set term postscript eps enhanced color "Times-Roman, 36" size 10,5
set output 'bands.eps'
set autoscale
set encoding iso_8859_1

Ef = 3.4270
K = 0.16/2
a = 2.46*4
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1


set palette defined (-0.5 'blue', -0.15 'grey', 0 'grey', 0.15 'grey', 0.5 'red')
set cbrange [-0.5:0.5]
set cbtics -1,0.5,1 offset -0.5,0
set cblabel "< s_z >" offset -0.7,0
set colorbox user origin 0.16,0.4 size 0.014,0.14

unset xtic
set tmargin 1
unset label
set bmargin 2
set size 0.37, 0.90
set origin 0.0, 0.02
set ytic auto out nomirror
set xrange [-3:3]
set tics out scale 2,1 nomirror
set yrange [-22:25]
unset key
set ytics -500,10,500 out nomirror offset 0.5,0
unset xtics
set xtics ("M" -3 , "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 3 ) out nomirror scale 2,1 offset 0,0.5
set ylabel "E - E_D [meV]" offset 1.5,0
set mytics 2
unset xtics
plot "./E-1/bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-3.3939)-12.93):9 every 5 palette lt 7 ps 1.8 lw 2 with points title "",\
"./E-1/bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-Ef-500)) lc rgb "black" lt 7 ps 1.8 lw 2 with points title "DFT",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($2)-12.93) with lines lw 5 lc rgb "black" title "Model",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($2)-12.93):38 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($3)-12.93):39 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($4)-12.93):40 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($5)-12.93):41 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($6)-12.93):42 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($7)-12.93):43 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($8)-12.93):44 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($9)-12.93):45 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($10)-12.93):46 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($11)-12.93):47 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($12)-12.93):48 palette lw 5 with lines title "",\
"./E-1/FITTING/bands_model.dat" using (($1*100)):(1000*($13)-12.93):49 palette lw 5 with lines title ""



unset xtic
set tmargin 1
unset label
set bmargin 2
set size 0.37, 0.90
set origin 0.25, 0.02
set ytic auto out nomirror
set xrange [-3:3]
set tics out scale 2,1 nomirror
set key inside center top samplen 1 box opaque
set ytics -500,10,500 out nomirror offset 0.5,0
unset xtics
set ylabel "E - E_F [meV]" offset 1.5,0
set mytics 2
set xtics ("M" -3 , "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 3 ) out nomirror scale 2,1 offset 0,0.5
unset ylabel
unset key
unset colorbox
plot "./../bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-3.4259)+4.17):9 every 5 palette lt 7 ps 1.8 lw 2 with points title "",\
"./../bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-Ef-500)) lc rgb "black" lt 7 ps 1.8 lw 2 with points title "DFT",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($2)+4.17) with lines lw 5 lc rgb "black" title "Model",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($2)+4.17):38 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($3)+4.17):39 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($4)+4.17):40 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($5)+4.17):41 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($6)+4.17):42 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($7)+4.17):43 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($8)+4.17):44 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($9)+4.17):45 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($10)+4.17):46 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($11)+4.17):47 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($12)+4.17):48 palette lw 5 with lines title "",\
"./../FITTING_new/bands_model.dat" using (($1*100)):(1000*($13)+4.17):49 palette lw 5 with lines title ""

unset xtic
set tmargin 1
unset label
set bmargin 2
set size 0.37, 0.90
set origin 0.5, 0.02
set ytic auto out nomirror
set xrange [-3:3]
set tics out scale 2,1 nomirror
set key inside center top samplen 1 box opaque
set ytics -500,10,500 out nomirror offset 0.5,0
unset xtics
set ylabel "E - E_F [meV]" offset 1.5,0
set mytics 2
set xtics ("M" -3 , "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 3 ) out nomirror scale 2,1 offset 0,0.5
unset ylabel
unset xtics
unset colorbox
plot "./E1/bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-3.4270)-10.59):9 every 5 palette lt 7 ps 1.8 lw 2 with points title "",\
"./E1/bandsK/spinbandsK.dat" using (($1-K)*dk):(1000*($2-Ef-500)) lc rgb "black" lt 7 ps 1.8 lw 2 with points title "DFT",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($2)-10.59) with lines lw 5 lc rgb "black" title "Model",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($2)-10.59):38 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($3)-10.59):39 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($4)-10.59):40 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($5)-10.59):41 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($6)-10.59):42 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($7)-10.59):43 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($8)-10.59):44 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($9)-10.59):45 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($10)-10.59):46 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($11)-10.59):47 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($12)-10.59):48 palette lw 5 with lines title "",\
"./E1/FITTING/bands_model.dat" using (($1*100)):(1000*($13)-10.59):49 palette lw 5 with lines title ""











