set term postscript eps enhanced color "Times-Roman, 30" size 4,6
set output 'bands3.eps'
set autoscale
set encoding iso_8859_1

Ef = 3.4259
K = 0.12/2
a = 2.46*4
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1


unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.98, 0.35
set origin 0.02, 0.01
set ytic auto out nomirror
set xrange [-3:3]
set tics out scale 2,1 nomirror
set yrange [-475:-360]
set key inside top center samplen 1 box opaque
set ytics -600,50,600 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
set xtics ("M" -3, "{/Symbol \254}    K    {/Symbol \256}" 0, "{/Symbol G}" 3 ) out nomirror scale 2,1
set x2tics ("4" -4, "2" -2, "0" 0, "2" 2, "4" 4) offset 0,-0.5
set mx2tics 4
unset x2tics
unset colorbox
set x2label "k [10^{-2}/{\305}]" offset 0,-0.5
unset x2label
unset key
plot "A3.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 7 lc rgb "red" title "G1",\
"B3.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 6 lc rgb "blue" title "G2"

unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.96, 0.35
set origin 0.04, 0.33
set ytic auto out nomirror
set tics out scale 2,1 nomirror
set yrange [-25:25]
set key inside top center samplen 1 box opaque
set ytics -600,20,600 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
unset key
plot "A3.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 7 lc rgb "red" title "A1",\
"B3.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 6 lc rgb "blue" title "G2"


unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.98, 0.35
set origin 0.02, 0.64
set ytic auto out nomirror
set tics out scale 2,1 nomirror
set yrange [360:450]
set key inside top center samplen 1 nobox opaque maxrows 2
set ytics -600,50,600 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
unset colorbox
plot "A3.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 7 lc rgb "red" title "A3",\
"B3.dat" using (($1-K)*dk):(1000*($2*Ry-Ef)):($3*5) every 2 ps variable pt 6 lc rgb "blue" title "B3"







