set term postscript eps enhanced color "Times-Roman, 30" size 12,7
set output 'bands_DOS.eps'
set autoscale
set encoding iso_8859_1

Ef = 0.0
K = 0.6666666/2
a = 2.46
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1


unset xtic
set xzeroaxis lw 3 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.275, 0.46
set origin 0.0, 0.55
set ytic auto out nomirror
set xrange [-10:10]
set tics out scale 2,1 nomirror
set yrange [-0.7:0.7]
set key inside top center samplen 1 box opaque
set ytics -9,0.3,9 out nomirror offset 0.8,0
unset xtics
set ylabel "E - E_F [eV]" offset 3,0
set mytics 2
set xtics ( "M    {/Symbol \254}    K    {/Symbol \256}    {/Symbol G}" 0.0 ) out nomirror scale 2,1 offset 0,0.5
unset colorbox
unset key
plot "./E0/band_so.dat.gnu" using (($1-K)*dk):(($2-0.0468)) every 30 lt 7 ps 1.5 lw 2 lc rgb "black" with points title "DFT",\
"./E0/bands_model.dat" using (($1*100)):(($2)) with lines lw 5 lc rgb "black" title "Model",\
"./E0/bands_model.dat" using (($1*100)):(($2)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($3)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($4)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($5)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($6)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($7)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($8)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($9)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($10)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($11)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($12)) lw 5 lc rgb "black" with lines title "",\
"./E0/bands_model.dat" using (($1*100)):(($13)) lw 5 lc rgb "black" with lines title ""


set size 0.275, 0.5
set origin 0.0, 0.05
set xrange [0:3.5]
set tics out scale 2,1 nomirror
set key inside top center samplen 1 box opaque
set xlabel "DOS [a.u.]" offset 0,0.8
set xtics 0,1,10 offset 0,0.5
set mytics 2
unset colorbox
unset key
plot "./E0/pwscf.pdos_tot" using 2:(($1-0.0468)) with lines lw 6 lc rgb "black" title ""



unset xtic
unset ylabel
unset xlabel
unset ytics
set ytics -9,0.3,9 out nomirror
set xzeroaxis lw 3 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.275, 0.46
set origin 0.18, 0.55
set xrange [-10:10]
unset xtics
set xtics ( "M    {/Symbol \254}    K    {/Symbol \256}    {/Symbol G}" 0.0 ) out nomirror scale 2,1 offset 0,0.5
unset colorbox
unset key
plot "./E0.25/band_so.dat.gnu" using (($1-K)*dk):(($2-0.0615)) every 30 lt 7 ps 1.5 lw 2 lc rgb "black" with points title "DFT",\
"./E0.25/bands_model.dat" using (($1*100)):(($2)) with lines lw 5 lc rgb "black" title "Model",\
"./E0.25/bands_model.dat" using (($1*100)):(($2)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($3)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($4)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($5)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($6)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($7)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($8)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($9)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($10)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($11)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($12)) lw 5 lc rgb "black" with lines title "",\
"./E0.25/bands_model.dat" using (($1*100)):(($13)) lw 5 lc rgb "black" with lines title ""


set size 0.275, 0.5
set origin 0.18, 0.05
set xrange [0:3.5]
set key inside top center samplen 1 box opaque
set xlabel "DOS [a.u.]" offset 0,0.8
set xtics 0,1,10 offset 0,0.5
set mytics 2
unset colorbox
unset key
plot "./E0.25/pwscf.pdos_tot" using 2:(($1-0.0615)) with lines lw 6 lc rgb "black" title ""

unset xtic
unset ylabel
unset xlabel
unset ytics
set ytics -9,0.3,9 out nomirror
set xzeroaxis lw 3 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.275, 0.46
set origin 0.36, 0.55
set xrange [-10:10]
unset xtics
set xtics ( "M    {/Symbol \254}    K    {/Symbol \256}    {/Symbol G}" 0.0 ) out nomirror scale 2,1 offset 0,0.5
unset colorbox
unset key
plot "./E0.5/band_so.dat.gnu" using (($1-K)*dk):(($2-0.0782)) every 30 lt 7 ps 1.5 lw 2 lc rgb "black" with points title "DFT",\
"./E0.5/bands_model.dat" using (($1*100)):(($2)) with lines lw 5 lc rgb "black" title "Model",\
"./E0.5/bands_model.dat" using (($1*100)):(($2)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($3)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($4)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($5)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($6)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($7)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($8)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($9)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($10)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($11)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($12)) lw 5 lc rgb "black" with lines title "",\
"./E0.5/bands_model.dat" using (($1*100)):(($13)) lw 5 lc rgb "black" with lines title ""


set size 0.275, 0.5
set origin 0.36, 0.05
set xrange [0:3.5]
set key inside top center samplen 1 box opaque
set xlabel "DOS [a.u.]" offset 0,0.8
set xtics 0,1,10 offset 0,0.5
set mytics 2
unset colorbox
unset key
plot "./E0.5/pwscf.pdos_tot" using 2:(($1-0.0782)) with lines lw 6 lc rgb "black" title ""

unset xtic
unset ylabel
unset xlabel
unset ytics
set ytics -9,0.3,9 out nomirror
set xzeroaxis lw 3 dt 3
set tmargin 1
unset label
set bmargin 2
set  size 0.275, 0.46
set origin 0.54, 0.55
set xrange [-10:10]
unset xtics
set xtics ( "M    {/Symbol \254}    K    {/Symbol \256}    {/Symbol G}" 0.0 ) out nomirror scale 2,1 offset 0,0.5
unset colorbox
unset key
plot "./E0.75/band_so.dat.gnu" using (($1-K)*dk):(($2-0.0951)) every 30 lt 7 ps 1.5 lw 2 lc rgb "black" with points title "DFT",\
"./E0.75/bands_model.dat" using (($1*100)):(($2)) with lines lw 5 lc rgb "black" title "Model",\
"./E0.75/bands_model.dat" using (($1*100)):(($2)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($3)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($4)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($5)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($6)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($7)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($8)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($9)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($10)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($11)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($12)) lw 5 lc rgb "black" with lines title "",\
"./E0.75/bands_model.dat" using (($1*100)):(($13)) lw 5 lc rgb "black" with lines title ""


set size 0.275, 0.5
set origin 0.54, 0.05
set xrange [0:3.5]
set key inside top center samplen 1 box opaque
set xlabel "DOS [a.u.]" offset 0,0.8
set xtics 0,1,10 offset 0,0.5
set mytics 2
unset colorbox
unset key
plot "./E0.75/pwscf.pdos_tot" using 2:(($1-0.0951)) with lines lw 6 lc rgb "black" title ""

unset xtic
unset ylabel
unset xlabel
unset ytics
set ytics -9,0.3,9 out nomirror
set xzeroaxis lw 3 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.275, 0.46
set origin 0.72, 0.55
set xrange [-10:10]
unset xtics
set xtics ( "M    {/Symbol \254}    K    {/Symbol \256}    {/Symbol G}" 0.0 ) out nomirror scale 2,1 offset 0,0.5
unset colorbox
unset key
plot "./E1/band_so.dat.gnu" using (($1-K)*dk):(($2-0.1112)) every 30 lt 7 ps 1.5 lw 2 lc rgb "black" with points title "DFT",\
"./E1/bands_model.dat" using (($1*100)):(($2)) with lines lw 5 lc rgb "black" title "Model",\
"./E1/bands_model.dat" using (($1*100)):(($2)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($3)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($4)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($5)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($6)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($7)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($8)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($9)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($10)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($11)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($12)) lw 5 lc rgb "black" with lines title "",\
"./E1/bands_model.dat" using (($1*100)):(($13)) lw 5 lc rgb "black" with lines title ""


set size 0.275, 0.5
set origin 0.72, 0.05
set xrange [0:3.5]
set key inside top center samplen 1 box opaque
set xlabel "DOS [a.u.]" offset 0,0.8
set xtics 0,1,10 offset 0,0.5
set mytics 2
unset colorbox
unset key
plot "./E1/pwscf.pdos_tot" using 2:(($1-0.1112)) with lines lw 6 lc rgb "black" title ""




