set term postscript eps enhanced color "Times-Roman, 28" size 6,6
set output 'bands.eps'
set autoscale
set encoding iso_8859_1

Ef = 0.0505
K = 0.6666666/2
a = 2.46
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1

unset xtic
set xzeroaxis lw 2 dt 3
set tmargin 1
set bmargin 2
set size 0.9, 0.95
set origin 0.0, 0.02
set xrange [-10:10.]
set ytic auto out nomirror offset 0.5,0
set tics out scale 2,1 nomirror
set yrange [-0.5:0.5]
unset xtics
unset key
set mytics 5
set title ""
set xtics ("M" -10, "K" 0.0, "{/Symbol G}" 10.0  ) out nomirror scale 2,1 offset 0,0.5
set ylabel "E - E_F [eV]" offset 3,-2
plot "./band_so.dat.gnu" using (($1-K)*dk):(($2-Ef)) every 15 lt 7 ps 1.8 lw 2 lc rgb "black" with points title "DFT",\
"./bands_model.dat" using (($1*100)):(($2)) with lines lw 5 lc rgb "black" title "Model",\
"./bands_model.dat" using (($1*100)):(($2)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($3)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($4)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($5)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($6)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($7)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($8)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($9)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($10)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($11)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($12)) lw 5 lc rgb "black" with lines title "",\
"./bands_model.dat" using (($1*100)):(($13)) lw 5 lc rgb "black" with lines title ""













