set term postscript eps enhanced color "Times-Roman, 30" size 12,8
set output 'bands_DOS.eps'
set autoscale
set encoding iso_8859_1

Ef = 0.0
K = 0.6666666/2
a = 2.46
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1


unset xtic
set xzeroaxis lw 3 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.28, 0.46
set origin 0.0, 0.55
set ytic auto out nomirror
set xrange [-12:12]
set tics out scale 2,1 nomirror
set yrange [-0.7:0.7]
set key inside top center samplen 1 box opaque
set ytics -600,0.2,600 out nomirror offset 0.8,0
unset xtics
set ylabel "E - E_F [eV]" offset 3,0
set mytics 2
set xtics ( "M    {/Symbol \254}    K    {/Symbol \256}    {/Symbol G}" 0.0 ) out nomirror scale 2,1 offset 0,0.5
unset colorbox
plot "./ABC/band_so.dat.gnu" using (($1-K)*dk):(($2-0.0505)) with lines lw 5 lc rgb "black" title "unrelaxed",\
"./ABC/band_so1.dat.gnu" using (($1-K)*dk):(($2-0.0454)) with lines lw 4 lc rgb "red" title "DFT-D2",\


set size 0.28, 0.5
set origin 0.0, 0.05
set xrange [0:3]
set tics out scale 2,1 nomirror
set key inside top center samplen 1 box opaque
set xlabel "DOS [a.u.]" offset 0,0.8
set xtics 0,1,10 offset 0,0.5
set mytics 2
unset colorbox
unset key
plot "./ABC/pwscf.pdos_tot" using 2:(($1-0.0505)) with lines lw 5 lc rgb "black" title "",\
"./ABC/pwscf.pdos_tot1" using 2:(($1-0.0454)) with lines lw 4 lc rgb "red" title "",\


unset xtic
unset ylabel
unset xlabel
unset ytics
set ytics -5,0.2,5 out nomirror
set xzeroaxis lw 3 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.28, 0.46
set origin 0.2, 0.55
set xrange [-12:12]
unset xtics
set xtics ( "M    {/Symbol \254}    K    {/Symbol \256}    {/Symbol G}" 0.0 ) out nomirror scale 2,1 offset 0,0.5
unset colorbox
unset key
plot "./ABA/band_so.dat.gnu" using (($1-K)*dk):(($2-0.0411)) with lines lw 5 lc rgb "black" title "",\
"./ABA/band_so1.dat.gnu" using (($1-K)*dk):(($2-0.0303)) with lines lw 4 lc rgb "red" title "",\


set size 0.28, 0.5
set origin 0.2, 0.05
set xrange [0:3]
set key inside top center samplen 1 box opaque
set xlabel "DOS [a.u.]" offset 0,0.8
set xtics 0,1,10 offset 0,0.5
set mytics 2
unset colorbox
unset key
plot "./ABA/pwscf.pdos_tot" using 2:(($1-0.0411)) with lines lw 5 lc rgb "black" title "",\
"./ABA/pwscf.pdos_tot1" using 2:(($1-0.0303)) with lines lw 4 lc rgb "red" title "",\

unset xtic
unset ylabel
unset xlabel
unset ytics
set ytics -5,0.2,5 out nomirror
set xzeroaxis lw 3 dt 3
set tmargin 1
unset label
set bmargin 2
set size 0.28, 0.46
set origin 0.4, 0.55
set xrange [-12:12]
unset xtics
set xtics ( "M    {/Symbol \254}    K    {/Symbol \256}    {/Symbol G}" 0.0 ) out nomirror scale 2,1 offset 0,0.5
unset colorbox
unset key
plot "./ABB/band_so.dat.gnu" using (($1-K)*dk):(($2-0.0468)) with lines lw 5 lc rgb "black" title "",\
"./ABB/band_so1.dat.gnu" using (($1-K)*dk):(($2-0.0528)) with lines lw 4 lc rgb "red" title "",\


set size 0.28, 0.5
set origin 0.4, 0.05
set xrange [0:3]
set key inside top center samplen 1 box opaque
set xlabel "DOS [a.u.]" offset 0,0.8
set xtics 0,1,10 offset 0,0.5
set mytics 2
unset colorbox
unset key
plot "./ABB/pwscf.pdos_tot" using 2:(($1-0.0468)) with lines lw 5 lc rgb "black" title "",\
"./ABB/pwscf.pdos_tot1" using 2:(($1-0.0528)) with lines lw 4 lc rgb "red" title "",\





