set term postscript eps enhanced color "Times-Roman,40" size 9,8
set output 'bands2.eps'
set autoscale
set encoding iso_8859_1

Ef = 0.0
a = 2.46
dk = 100*2*3.141592/a
Ry = 13.605693
set multiplot layout 2,1


unset xtic
set xzeroaxis lw 2 dt 2
set tmargin 1
unset label
set bmargin 2
set size 0.98, 0.7
set origin 0.02, 0.3
set ytic auto out nomirror
set xrange [0.0:0.10791231]
set tics out scale 2,1 nomirror
set yrange [-125:125]
set key inside top center samplen 1 nobox opaque
set ytics -600,50,600 out nomirror
unset xtics
set ylabel "E - E_F [meV]" offset 0.5,0
set mytics 2
set xtics ("M" 0.0, "{/Symbol \254}    K    {/Symbol \256}" 0.05406428, "{/Symbol G}" 0.10791231 ) out nomirror scale 2,1
unset colorbox
plot "bso.dat" using 1:(1000*($2)) with lines lw 7 lc rgb "black" title "SOC",\
"bso_field.dat" using 1:(1000*($2)) with lines lw 7 dt 4 lc rgb "green" title "0.2V/nm",\



unset xtic
set xzeroaxis lw 2 dt 2
set tmargin 1
unset label
set bmargin 2
set size 0.96, 0.3
set origin 0.04, 0.0
set ytic auto out nomirror
set xrange [0.0:0.10791231]
set tics out scale 2,1 nomirror
set yrange [0:30]
set key inside top left samplen 1 nobox opaque
set ytics -600,10,600 out nomirror
unset xtics
set ylabel "splitting [{/Symbol m}eV]" offset 0.5,0
set mytics 2
set xtics ("M" 0.0, "{/Symbol \254}    K    {/Symbol \256}" 0.05406428, "{/Symbol G}" 0.10791231 ) out nomirror scale 2,1
unset colorbox
plot "split_bso_val.dat" using 1:(1000000*($5-$2)) with lines lw 7 lc rgb "red" title "val",\
"split_bso_cond.dat" using 1:(1000000*($5-$2)) with lines lw 7 lc rgb "blue" title "cond",\
"split_bso_field_val.dat" using 1:(1000000*($5-$2)) with lines lw 7 dt 4 lc rgb "red" title "",\
"split_bso_field_cond.dat" using 1:(1000000*($5-$2)) with lines lw 7 dt 4 lc rgb "blue" title "",\





